IF OBJECT_ID('dbo.MJ_SuperRight') IS NULL
	CREATE TABLE dbo.MJ_SuperRight (
	       Super_No             int IDENTITY(1,1) NOT NULL,
	       Super_Type           tinyint NULL,
	       Person_ID            int NULL,
	       Card_No              varchar(12) NULL,
	       Super_Pwd            varchar(8)  NULL,
	       PRIMARY KEY (Super_No ASC)
	)
GO

IF OBJECT_ID('dbo.MJ_AlarmRecord') IS NULL
	CREATE TABLE dbo.MJ_AlarmRecord (
	       ID_KEY               int IDENTITY,
	       Alarm_Time           datetime NOT NULL,
	       Ctrl_No              varchar(4) NOT NULL,	       
	       Dot_Name             varchar(40) NULL,
	       Event_Code           int NULL,
	       Is_InDoor            bit NOT NULL DEFAULT 1,
	       PRIMARY KEY (ID_KEY ASC)
	)
GO

IF OBJECT_ID('dbo.MJ_AbnormRecord') IS NULL
	CREATE TABLE dbo.MJ_AbnormRecord (
	       ID_KEY               int IDENTITY,
	       BrushCard_Time       datetime NOT NULL,
	       Ctrl_No              varchar(4) NOT NULL,	       
	       Door_No              int NULL,
	       Door_Name            varchar(40) NULL,
	       Card_No              varchar(12) NULL,
	       Event_Code           int NULL,
	       Is_InDoor            bit NOT NULL DEFAULT 1,
	       PRIMARY KEY (ID_KEY ASC)
	)
GO

IF OBJECT_ID('dbo.MJ_NormalRecord') IS NULL
CREATE TABLE dbo.MJ_NormalRecord (
       ID_KEY               int IDENTITY,
       BrushCard_Time       datetime NOT NULL,
       Person_ID            int NOT NULL,
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NULL,
       Door_Name            varchar(40) NULL,
       Card_No              varchar(12) NULL,
       Event_Code           int NULL,
       Is_InDoor            bit NOT NULL DEFAULT 1,
       PRIMARY KEY (ID_KEY ASC)
)
GO

IF OBJECT_ID('dbo.MJ_PsnSpecDate') IS NULL
CREATE TABLE dbo.MJ_PsnSpecDate (
       ID_KEY               int IDENTITY,
       SpecTime_No          int NULL,
       Spec_Date            varchar(10) NOT NULL,
       PRIMARY KEY (ID_KEY ASC)
)
GO

IF OBJECT_ID('dbo.MJ_PsnSpecTime') IS NULL
CREATE TABLE dbo.MJ_PsnSpecTime (
       ID_KEY               int IDENTITY,
       SpecTime_No          int NOT NULL,
       Start_Time           varchar(5) NOT NULL,
       End_Time             varchar(5) NOT NULL,
       PRIMARY KEY (ID_KEY ASC)
)
GO

IF OBJECT_ID('dbo.MJ_PsnInOutTime') IS NULL
CREATE TABLE dbo.MJ_PsnInOutTime (
       PsnTime_No           int NOT NULL,
       PsnTime_Name         varchar(20) NOT NULL,
       Start_Date           varchar(10) NOT NULL,
       End_Date             varchar(10) NULL,
       Rule_Type            tinyint NOT NULL DEFAULT 0,
       Cycle_Total          int NULL,
       SpecTime_Info        tinyint NULL,
       PRIMARY KEY (PsnTime_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_PsnInOutTimeSub') IS NULL
CREATE TABLE dbo.MJ_PsnInOutTimeSub (
       ID_KEY               int IDENTITY,
       PsnTime_No           int NOT NULL,
       Group_No             varchar(2) NOT NULL,
       TimeSect_ID          smallint NOT NULL,
       Start_Time           varchar(5) NOT NULL,
       End_Time             varchar(5) NOT NULL,
       PRIMARY KEY (ID_KEY ASC), 
)
GO

IF OBJECT_ID('dbo.MJ_DoorSpecWeek') IS NULL
CREATE TABLE dbo.MJ_DoorSpecWeek (
       SpecTime_No          int NOT NULL,
       Week_Info            tinyint NULL,
       PRIMARY KEY (SpecTime_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_DoorSpecDate') IS NULL
CREATE TABLE dbo.MJ_DoorSpecDate (
       ID_KEY               int IDENTITY,
       SpecTime_No          int NOT NULL,
       Spec_Date            varchar(10) NOT NULL,
       PRIMARY KEY (ID_KEY ASC)
)
GO

IF OBJECT_ID('dbo.MJ_Person') IS NULL
CREATE TABLE dbo.MJ_Person (
       Person_ID            int NOT NULL,
       Door_Pwd             varchar(255) NULL DEFAULT 111111,
       Person_State         tinyint NULL,
       User_No              varchar(20) NULL,
       Update_Date          datetime NULL DEFAULT getdate(),
       Acs_Card             varchar(20) NULL,
       LastIn_Time          DATETIME,
       LastIn_Ctrl          VARCHAR(4),
       LastIn_Door          INT,
       LastOut_Time         DATETIME,
       LastOut_Ctrl         VARCHAR(4),
       LastOut_Door         INT,
       PRIMARY KEY (Person_ID ASC)
)
GO

IF OBJECT_ID('dbo.MJ_PsnDoorRight') IS NULL
CREATE TABLE dbo.MJ_PsnDoorRight (
       Person_ID            int NOT NULL,
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NOT NULL,
       PsnTime_No           int NULL,
       FirstCardOpen        bit NOT NULL DEFAULT 0, 
       PRIMARY KEY (Person_ID ASC, Ctrl_No ASC, Door_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_SysParam') IS NULL
CREATE TABLE dbo.MJ_SysParam (
       Param_ID             int IDENTITY,
       Param_Code           varchar(20) NOT NULL,
       Param_Name           varchar(40) NOT NULL,
       Param_Value          varchar(100) NOT NULL,
       PRIMARY KEY (Param_ID ASC)
)
GO

IF OBJECT_ID('dbo.MJ_Controller') IS NULL
CREATE TABLE dbo.MJ_Controller (
       Ctrl_No              varchar(4) NOT NULL,
       Ctrl_Name            varchar(20) NOT NULL,
       Ctrl_Type            varchar(20) NOT NULL,
       IP_Addr              varchar(15) NULL,
       Com_Addr             varchar(10) NULL,
       Is_Extend            bit NOT NULL DEFAULT 0,
       Is_Online            bit NULL DEFAULT 0,
       InterLock_Info       tinyint NULL,
       LastUpload           DATETIME NOT NULL DEFAULT '2007-01-01',
       Users_No             VARCHAR(2100) DEFAULT '',
       Is_Video             BIT NOT NULL DEFAULT 0,
       Video_IP             VARCHAR(20),
       PRIMARY KEY (Ctrl_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_Door') IS NULL
CREATE TABLE dbo.MJ_Door (
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NOT NULL,
       Door_Name            varchar(20) NOT NULL,
       Door_Type            tinyint NOT NULL DEFAULT 0,
       DoorMagic_State      tinyint NOT NULL DEFAULT 0,
       DoorBtn_State        tinyint NOT NULL DEFAULT 0,
       DoorLock_State       tinyint NOT NULL DEFAULT 0,
       DoorLock_TimeLen     tinyint NOT NULL DEFAULT 1,
       DoorClose_TimeLen    tinyint NOT NULL DEFAULT 3,
       OpenAlarm_TimeLen    tinyint NOT NULL DEFAULT 5,
       CardReader_Type      tinyint NOT NULL DEFAULT 0,
       ReadCard_Mode        tinyint NOT NULL DEFAULT 0,
       Card_Number          tinyint NOT NULL DEFAULT 1,
       Menace_Pwd           varchar(5) NOT NULL DEFAULT 99999,
       Is_APB               bit NOT NULL DEFAULT 0,
       Is_HiddenBack        bit NOT NULL DEFAULT 0,
       Is_PwdKeyBoard       bit NOT NULL DEFAULT 0,
       Allow_HoldNumber     int NOT NULL DEFAULT 0,
       Is_ReadCardAttend    bit NOT NULL DEFAULT 0,
       DoorTime_No          int NULL,
       LockWithDoor         tinyint DEFAULT 0 NOT NULL,
       Which_Door           int,
       MeetingMode          int Null Default 0,
       IP                   varchar(20) Null,
       HideBack_No          varchar(20) NULL,
       APB_No               varchar(20) NULL,
       DVSMode              tinyint NOT NULL DEFAULT 0,
       DVSServerIP          varchar(20) null,
)
GO

IF OBJECT_ID('dbo.MJ_CtrlDot') IS NULL
CREATE TABLE dbo.MJ_CtrlDot (
       Ctrl_No              varchar(4) NOT NULL,
       Dot_No               varchar(10) NOT NULL,
       Dot_Name             varchar(20) NOT NULL,
       Dot_Type             tinyint NOT NULL DEFAULT 0,
       Dot_State            tinyint NULL,
       Is_Input             bit NULL DEFAULT 0,
       Is_Extend            bit NULL DEFAULT 0,
       Is_Auto              bit NULL DEFAULT 1,
       PRIMARY KEY (Ctrl_No ASC, Dot_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_AlarmOut') IS NULL
CREATE TABLE dbo.MJ_AlarmOut (
       Ctrl_No      varchar(4)  NOT NULL,
	     Idx_No       tinyint NOT NULL,
	     Door_Info    tinyint NOT NULL,
	     OutputDot_No tinyint NOT NULL,
	     Output_Time  tinyint NOT NULL,
	     Event_Open   int NOT NULL,
       Event_Alarm  int NOT NULL,
	     Event_Close  int NOT NULL, 
       PRIMARY KEY (Ctrl_No ASC, Idx_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_DotLinkage') IS NULL
CREATE TABLE dbo.MJ_DotLinkage (
       Ctrl_No              varchar(4) NOT NULL,
       Linkage_No           varchar(4) NOT NULL,
       Dot_No               varchar(10) NOT NULL,
       Linkage_Name         varchar(20) NOT NULL,
       Is_Input             bit NULL,
       Dot_State            tinyint NULL,
       PRIMARY KEY (Ctrl_No ASC, Linkage_No ASC, Dot_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_UrgencyGroup') IS NULL
CREATE TABLE dbo.MJ_UrgencyGroup (
       UrgGrp_No            varchar(4) NOT NULL,
       UrgGrp_Name          varchar(20) NOT NULL,
       PRIMARY KEY (UrgGrp_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_UrgencyGroupSub') IS NULL
CREATE TABLE dbo.MJ_UrgencyGroupSub (
       UrgGrp_No            varchar(4) NOT NULL,
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NOT NULL,
       PRIMARY KEY (UrgGrp_No ASC, Ctrl_No ASC, Door_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_MapInfo') IS NULL
CREATE TABLE dbo.MJ_MapInfo (
       Map_No               varchar(4) NOT NULL,
       Map_Name             varchar(20) NOT NULL,
       Map_Image            image NULL,
       Door_TotalNum        int NULL,
       PRIMARY KEY (Map_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_MapDot') IS NULL
CREATE TABLE dbo.MJ_MapDot (
       Map_No               varchar(4) NOT NULL,
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NOT NULL,
       Site_X               int NULL,
       Site_Y               int NULL,
       PRIMARY KEY (Map_No ASC, Ctrl_No ASC, Door_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_DoorSwitchTime') IS NULL
CREATE TABLE dbo.MJ_DoorSwitchTime (
       DoorTime_No          int NOT NULL,
       DoorTime_Name        varchar(20) NOT NULL,
       SpecTime_Info        tinyint NULL,
       PRIMARY KEY (DoorTime_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_DoorSwitchTimeSub') IS NULL
CREATE TABLE dbo.MJ_DoorSwitchTimeSub (
       DoorTime_No          int NOT NULL,
       Start_Time           varchar(5) NOT NULL,
       End_Time             varchar(5) NOT NULL,
       Door_State           tinyint NOT NULL,
       PRIMARY KEY (DoorTime_No ASC, Start_Time ASC, End_Time ASC)
)
GO

IF OBJECT_ID('dbo.MJ_DoorSpecTime') IS NULL
CREATE TABLE dbo.MJ_DoorSpecTime (
       ID_KEY               int IDENTITY,
       SpecTime_No          int NOT NULL,
       Start_Time           varchar(5) NOT NULL,
       End_Time             varchar(5) NOT NULL,
       Door_State           tinyint NOT NULL,
       PRIMARY KEY (ID_KEY ASC)
)
GO

IF OBJECT_ID('dbo.MJ_ExtendFunc') IS NULL
CREATE TABLE dbo.MJ_ExtendFunc (
       Menu_No              varchar(20) NOT NULL,
       Menu_Name            varchar(20) NOT NULL,
       Is_Menu              bit NULL DEFAULT 0,
       Is_Use               bit NOT NULL DEFAULT 0,
       PRIMARY KEY (Menu_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_ControlInfo') IS NULL
CREATE TABLE dbo.MJ_ControlInfo (
       Ctrl_No              varchar(4) NOT NULL,
       Door_No              int NOT NULL,
       Person_ID            int NOT NULL,
       Card_No              varchar(20) NULL,
       Description          varchar(40) NULL,
       Door_State           tinyint NULL,
       Record_Color         tinyint NULL,
       Run_Time             datetime NULL,
       Run_Info             varchar(80) NULL,
       Alarm_Info           varchar(80) NULL,
       State_Info           varchar(40) NULL,
       Update_Time          datetime NULL,       
       PRIMARY KEY (Ctrl_No ASC, Door_No ASC)
)
GO

IF OBJECT_ID('dbo.MJ_ResParam') IS NULL
CREATE TABLE dbo.MJ_ResParam (
       Ctrl_Type            tinyint NOT NULL,
       Ctrl_Name            varchar(20) NULL,
       Res_Type             tinyint NOT NULL,
       Idx_No               tinyint NULL,
       Res_Name             varchar(20) NULL,
       Res_Number           tinyint NULL,
       Is_Extend            bit NULL,
       PRIMARY KEY (Ctrl_Type ASC, Res_Type ASC) 
)
GO

IF OBJECT_ID('dbo.MJ_DoorMultiCard') IS NULL
CREATE TABLE [dbo].[MJ_DoorMultiCard] (
	Ctrl_No     varchar(4) NOT NULL,
	Door_No     int NOT NULL,
	Value_Type  varchar(6)  NOT NULL ,
	Value       varchar(12)  NULL 
	PRIMARY KEY (Ctrl_No ASC, Door_No ASC, Value_Type ASC) 
)
GO

IF OBJECT_ID('dbo.MJ_CardManager') IS NULL
CREATE TABLE [dbo].[MJ_CardManager] (
	Ctrl_No   varchar(4) NOT NULL,
	Door_No   int NOT NULL,
	Person_ID int NOT NULL,
	Use_Type  tinyint NOT NULL,
	PRIMARY KEY (Ctrl_No ASC, Door_No ASC,Person_ID ASC)  
)
GO

IF OBJECT_ID('dbo.MJ_EventInfo') IS NULL
CREATE TABLE dbo.MJ_EventInfo(
	Event_Type   tinyint NOT NULL,
	Event_Code   tinyint NOT NULL,
	Event_Name   varchar(40) NOT NULL, 
  Record_Color tinyint NULL,
  Info_Style   varchar(20),
	PRIMARY KEY (Event_Type ASC, Event_Code ASC)
)
GO

IF OBJECT_ID('dbo.MJ_ChangeHistory') IS NULL
CREATE TABLE dbo.MJ_ChangeHistory(
	ID_Key       int IDENTITY (1, 1) NOT NULL,
	Person_ID    int NULL,
	Change_State tinyint NULL,
	Change_Value varchar(40) NULL,
	Change_Ctrl  varchar(10) NULL,
	Change_Date  datetime NULL,
	PRIMARY KEY (ID_Key ASC)
)
GO

IF OBJECT_ID('dbo.MJ_Solution') IS NULL
CREATE TABLE dbo.MJ_Solution (
	Solution_ID int NOT NULL,
	Solution_No varchar(40) NOT NULL,
	Solution_Name varchar(40) NOT NULL,
	Ctrl_No varchar(4) NOT NULL,
	Door_No int NOT NULL,
	PsnTime_No int NULL,
	PRIMARY KEY (Solution_ID ASC, Ctrl_No ASC, Door_No ASC) 
)
GO

IF OBJECT_ID('dbo.MJ_MeetingInfo') IS NULL
	CREATE TABLE dbo.MJ_MeetingInfo (
	       ID_Key             int IDENTITY(1,1) NOT NULL,
	       Ctrl_No            varchar(20) NOT NULL,
	       Door_No            varchar(20) NULL,
	       Bgn_Date           varchar(10) NULL,
	       Bgn_Time           varchar(5) NULL,
	       End_Date           varchar(10) NULL,
	       End_Time           varchar(5) NULL,
	       Remark             varchar(40) NULL,
	       PRIMARY KEY (ID_Key ASC)
	)
GO


IF OBJECT_ID('dbo.MJ_MeetingPerson') IS NULL
	CREATE TABLE dbo.MJ_MeetingPerson (
	       ID_Key             int IDENTITY(1,1) NOT NULL,
	       Ctrl_No            varchar(20) NOT NULL,
	       Door_No            varchar(20) NULL,
	       Person_ID          int,
	       PRIMARY KEY (ID_Key ASC)
	)
GO

IF OBJECT_ID('MJ_PersonLastInfo') IS NULL
   CREATE TABLE MJ_PersonLastInfo(
      ID_KEY INT IDENTITY(1,1),
      Person_ID INT NOT NULL,
      APB_No VARCHAR(4),
      HideBack_No VARCHAR(4),
      LastIn_Time DATETIME,
      LastIn_Ctrl VARCHAR(4),
      LastIn_Door INT,
      LastOut_Time DATETIME,
      PRIMARY KEY (ID_KEY)
   )
GO


IF OBJECT_ID('MJ_DVSVideoInfo') IS NULL
CREATE TABLE MJ_DVSVideoInfo (
      ID_KEY  int IDENTITY (1, 1) NOT NULL ,
      Card_No varchar(20) NULL ,
      Brush_Time varchar(8) NULL ,
      Brush_Date varchar(10) NULL ,
      [File_Name] varchar(30) NULL ,
      File_Path varchar(100) NULL ,
      Remark varchar(50) NULL ,
      PRIMARY KEY (ID_KEY)
) ON [PRIMARY]
GO




if not exists (select * from dbo.sysindexes where name = N'IX_MJ_DVSVideoInfoCardNo' and id = object_id(N'MJ_DVSVideoInfo'))
  CREATE  INDEX IX_MJ_DVSVideoInfoCardNo ON MJ_DVSVideoInfo(Card_No) ON [PRIMARY]
GO

if not exists (select * from dbo.sysindexes where name = N'IX_MJ_DVSVideoInfoBrushTime' and id = object_id(N'MJ_DVSVideoInfo'))
  CREATE  INDEX IX_MJ_DVSVideoInfoBrushTime ON MJ_DVSVideoInfo(Brush_Time) ON [PRIMARY]
GO

if not exists (select * from dbo.sysindexes where name = N'IX_MJ_DVSVideoInfoBrushDate' and id = object_id(N'MJ_DVSVideoInfo'))
  CREATE  INDEX IX_MJ_DVSVideoInfoBrushDate ON MJ_DVSVideoInfo(Brush_Date) ON [PRIMARY]
GO